//
// Fragment shader for doing Gaussian blur 
//
// Author: Shirley Carter
//

const float kSmall = 0.1;

uniform sampler2DRect texUnit;	// obvious 
uniform vec4 textureRect;

uniform float edgeBlurWidth;	// image's radius(=sqrt(imageWidth/2**2+ imageHeight/2**2) *blur%(=value from the first slider ) on the cue inspector.
		 						// this represents how much image area gets blurred measuring from image edges.
                                
uniform float drawRadius;		// image's radius(= sqrt(imageWidth/2**2+ imageHeight/2**2 )
uniform float blurRadius;		// number of pixels around each pixel particiapting the gaussian averaging calculation to produce blurry effect.

								// this shader gets called twice to use 2*N approach to achieve close enough Gaussian blur effect via N*N approach 
uniform bool renderingLocalH;   // this flag shader to do Gaussian avage along horizontal line of pixels. 
uniform bool renderingLocalV;	// this flag shader to do Gaussina avage along vertical line of pixels. 
uniform  vec4 modulateColor;

uniform vec2 drawingOffset;
uniform vec2 drawingScale;
uniform vec4 drawingBoundsRect;
uniform vec4 destRect; 

varying vec2 gUV;

void main(void)
{
    
        vec3 vCoord = gl_FragCoord.xyz;
        vec2 t0 = vCoord.xy; 
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w; 
        
        // Transform back to render traget coord space
        vCoord /= vec3(drawingScale, 1);
        vCoord += vec3(drawingOffset, 0);


        vec4 outputColor = texture2DRect(texUnit, gUV);
        vec3 hsv; 
        int radius; 
        
        vec4 result = vec4(0.0,0.0, 0.0, 0.0);
        
        float fradius = blurRadius;
        
        bool doBlur = false;	
        int color = 0;
        
        
        float drawBoundLeft = drawingBoundsRect.x;
        float drawBoundRight = drawingBoundsRect.x + drawingBoundsRect.z;
        float drawBoundTop = drawingBoundsRect.y; 
        float drawBoundBottom = drawingBoundsRect.y+drawingBoundsRect.w; 

        float centerX = 0.5*(drawBoundLeft+drawBoundRight); 
        float centerY = 0.5*(drawBoundTop+drawBoundBottom); 
        
        float d0 = drawRadius-edgeBlurWidth;
        float d = length(vec2(vCoord.x-centerX,vCoord.y-centerY));
        
        float destWidth = (destRect.z -destRect.x);
        float destHeight = (destRect.w - destRect.y);
        
        if ( edgeBlurWidth > kSmall && d> d0) {
            fradius = blurRadius/edgeBlurWidth*(d-d0); 
            doBlur = true; 
            color = 0; 
        }
        else  {
            fradius = 0.0;
            doBlur = false;  
            color = 0; 
        }
        if ( doBlur && fradius > kSmall) {
                
            float sigma = fradius; 
            float sigma22 = 2.0*sigma*sigma; 
            float sigma2pi22 = sqrt(2.0*3.1415926 * sigma *sigma); 
            
            float sum = 0.0;
            int radius = int(fradius); 
        
            float distance; 
            float f, fcol, frow;
            float x, y; 
            if ( renderingLocalH) {

                for ( int col = 0; col < 2*radius+1;  col ++ ) {
                
                    fcol = float(col-radius);
                    x = t0.x +fcol;

                    x = 1.0/destWidth*(x-destRect.x);
                    x = clamp(x, 0.0, 1.0); 
                   
                    distance = fcol*fcol;
                    f = exp2(-distance/sigma22*1.442695)  /sigma2pi22; 
                    vec4 texColor = texture2DRect(texUnit, vec2(x*textureWidth, gUV.y));
                    result +=  f*texColor;
                    sum += f;
                }    
                if ( abs(sum) > kSmall) 
                    outputColor =  result/sum;
            }
            else if (renderingLocalV) {

                for ( int row =0; row < 2*radius+1; row ++ ) {
                    
                    frow = float(row-radius);
                    y = t0.y + frow;
                    y = 1.0/destHeight*(y-destRect.y);
                    y = clamp(y, 0.0, 1.0); 
                    distance = frow*frow;
                    f = exp2(-distance/sigma22*1.442695)  /sigma2pi22;
                            
                    vec4 texColor = texture2DRect(texUnit, vec2(gUV.x, y*textureHeight));
                    result +=  f*texColor; 			
                    sum += f;
                } 
                if ( abs(sum) > kSmall )
                    outputColor = result/sum;

            }

            if ( color ==1 )
                outputColor = vec4(1,0,0,1); 
            else if ( color ==2 )
                outputColor = vec4(1,1,0,1); 
            else if ( color ==3 )
                outputColor = vec4(0,0,1,1);
            else if ( color ==4 )
                outputColor = vec4(1,0,1,1);  
        
        }
        //else
        //   outputColor = vec4(0,0,1,1);
           
        gl_FragColor =  modulateColor *outputColor;
    
}

